"""Module which provides functionality to compute descriptors."""

import numpy as np
from scipy.spatial.distance import pdist

class Distance:

    """Distance matrix descriptors."""

    def __init__(self, **kwargs):
        self.set_options(**kwargs)

    def set_options(self, **kwargs):
        """Given an option dictionary set the valid options and
        raise an error if there are invalid ones."""
        if len(kwargs) > 0:
            raise ValueError("Invalid arguments given to the descriptor class.")

    def compute(self, coords: np.ndarray) -> np.ndarray:
        """Compute the distance matric as a descriptor."""
        return pdist(coords, metric="euclidean")

class Coulomb(Distance):

    """Coulomb matrix descriptors."""

    def compute(self, coords: np.ndarray) -> np.ndarray:
        """Compute the Coulomb matrix as a descriptor."""
        return 1.0/super().compute(coords)
